#!/bin/bash
# 检测命令
echo "==========================================================================" >> logrotate-report.log
date >> logrotate-report.log

echo "手动执行日志滚动 ..."
echo "手动执行日志滚动 ..." >> logrotate-report.log
logrotate /etc/logrotate.conf >> logrotate-report.log

echo "检查系统日志是否有关于logrotate的相关信息 ..."
echo "检查系统日志是否有关于logrotate的相关信息 ..." >> logrotate-report.log
if [ -f /var/log/messages ] ; then
    grep "logrotate" /var/log/messages >> logrotate-report.log
fi
if [ -f /var/log/kern.log ] ; then
    grep "logrotate" /var/log/kern.log >> logrotate-report.log
fi
echo "检查logrotate状态 ..."
echo "检查logrotate状态 ..." >> logrotate-report.log
logrotate_statue_files=(
    /var/lib/logrotate.status
    /var/lib/logrotate/logrotate.status
    /var/lib/logrotate/status 
)
for f in ${logrotate_statue_files[@]} 
do
    echo "检查文件${f} ..."
    echo "检查文件${f} ..." >> logrotate-report.log
    if [ -f ${f} ] ; then
        cat ${f} >> logrotate-report.log
    fi
done
echo "检查sniperknl日志归档定时任务状态 ..."
echo "检查sniperknl日志归档定时任务状态 ..." >> logrotate-report.log
files=(
    /etc/rsyslog.d/sniperknl-rsyslog.conf
    /etc/logrotate.d/sniperknl-logrotate
    /etc/cron.d/sniperknl-crontab
    /usr/local/sniper/sniperknl-crontab-script.sh
    /usr/local/sniper/sniperknl-logrotate-report.sh
)
for f in ${files[@]}
do
    if [ -f ${f} ] ; then
        echo "已安装 ${f}"
        echo "已安装 ${f}" >> logrotate-report.log
    else
        echo "未安装 ${f}"
        echo "未安装 ${f}" >> logrotate-report.log
    fi
done