#!/usr/bin/env bash

function remove_big_files() {
    if [ ! -d /usr/local/sniper/logs ] ; then
        return
    fi
    
    for file in $(find /usr/local/sniper/logs -type f 2>/dev/null)
    do
    file_size=`stat ${file} | grep Size | awk '{print $2}'`
    
    if [ ! $file_size ] ; then
        continue
    fi

    echo "${file} size: ${file_size} byte!"
    if [ $file_size -gt 2097152 ] ; then
        rm -rf ${file}
        echo "rm -rf '${file}'"
    fi 
    done
}

function config_client_log() {
    echo "upgrade the client's logger configuration file ..."
    if [ ! -d /usr/local/sniper ] ; then
        echo "You need to install the sniper client."
        exit 1
    fi

    # 替换日志配置文件
    cp config/* /usr/local/sniper/config

    # 重启客户端
    echo "stop the sniper client ..."
    /usr/local/sniper/shutdown.sh
    sniper_pid=`ps -ef | grep sniper | grep -v grep | grep -v sniperknl`
    if [ "#${sniper_pid}" == "#" ] ;  then
        echo "sniper client is stop."
    else
        echo "stop the client failed!!!"
    fi

    # 检测
    remove_big_files
    echo "sniper logs: `ls -lh /usr/local/sniper/logs`"
}

config_client_log
